<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;

    public function room()
    {
        return $this->belongsTo(ClassRoom::class,'room_id');
    }

    public function questions()
    {
        return $this->hasMany(Question::class,'exam_id');
    }

    public function uploaded()
    {
        return $this->hasMany(UploadedExam::class,'exam_id');
    }

    #Scope
######################
#######################
    public function scopePreExam($query)
    {
        return $query->where('type', 0);
    }
    public function scopePost($query)
    {
        return $query->where('type', 1);
    }
    public function scopePass($query)
    {
        return $query->where('type', 2);
    }

}
